/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.scc.model.rules;

import com.vistara.sdk.utils.StringUtil;
import com.vistara.timeseries.collection.SourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum RuleEntity {
    DEVICE("Device"),
    USER("User"),
    ALERT("Alert"),
    SERVICEGROUP("Service"),
    RULEDEFINITION("Rule Definition"),
    REPORT("Report"),
    DEVICEGROUP("Device Group"),
    AUTO_SCALING("Auto Scaling"),
    DYNAMO_DB("DynamoDB"),
    RDS("RDS"),
    REDSHIFT("Redshift"),
    ROUTE_53("Route 53"),
    SNS("SNS"),
    SQS("SQS"),
    LOAD_BALANCER("Load Balancer"),
    EBS("Volume"),
    ELASTICACHE("ElastiCache"),
    ELASTICACHENODE("ElastiCache Node"),
    REDSHIFTCLUSTERNODE("Redshift Cluster Node"),
    ELASTIC_IP("Elastic Ip"),
    DEPENDENCY_GROUP("Dependency Group"),
    ELASTICMAPREDUCE("Elastic MapReduce"),
    EMRINSTANCEGROUP("EMR Instance Group"),
    EMRSTEP("EMR Step"),
    EMRBOOTSTRAPACTION("EMR Bootsrap Action"),
    AFFINITY_GROUP("AffinityGroup"),
    CLOUD_SERVICE("CloudService"),
    ALL("All"),
    INCIDENT("Incident"),
    CHANGE("Change Request"),
    SERVICEREQUEST("Service Request"),
    PROBLEM("Problem"),
    SITE("Site"),
    KINESIS("Kinesis"),
    VPN("AWS/VpnConnection"),
    GLOBAL_SECONDARY_INDEX("globalsecondaryindex"),
    LAMBDA("lambda"),
    MACHINE_LEARNING("machinelearning"),
    STORAGE_GATEWAY("storagegateway"),
    GATEWAY_VOLUME("gatewayvolume"),
    CHECK("Check"),
    CLOUDFRONT("CloudFront"),
    WEBSITE("WebSite"),
    SQL_SERVER("SQL Server"),
    SQL_DATABASE("SQL Database"),
    ESCALATE_ALERT("EscalateAlert"),
    DATA_CENTER("Data Center"),
    VI_DATASTORE("Data Store"),
    VI_CLUSTER("Cluster");

    private String name;
    private static List<RuleEntity> ruleEntities;

    private RuleEntity(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static RuleEntity getRuleEntity(String ruleEntity) {
        for (RuleEntity value : RuleEntity.values()) {
            if (!value.name().equalsIgnoreCase(ruleEntity)) continue;
            return value;
        }
        throw new IllegalArgumentException("No Enum specified for this string");
    }

    public List<String> getRuleAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.equals((Object)DEVICE)) {
            attributes.add("deviceState");
            attributes.add("deviceType");
        } else if (this.equals((Object)DEVICEGROUP) || this.equals((Object)SITE)) {
            attributes.add("sysEventTime");
        }
        attributes.add("location");
        return attributes;
    }

    public static RuleEntity parse(String name) {
        if (name != null) {
            return RuleEntity.valueOf(name.toUpperCase());
        }
        return null;
    }

    public static RuleEntity lookup(String name) {
        for (RuleEntity type : RuleEntity.values()) {
            if (!type.name().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static List<RuleEntity> getRuleEntitiesByCloudResources() {
        if (ruleEntities == null) {
            ruleEntities = new ArrayList<RuleEntity>();
            ruleEntities.add(AUTO_SCALING);
            ruleEntities.add(DYNAMO_DB);
            ruleEntities.add(RDS);
            ruleEntities.add(REDSHIFT);
            ruleEntities.add(ROUTE_53);
            ruleEntities.add(SNS);
            ruleEntities.add(SQS);
            ruleEntities.add(LOAD_BALANCER);
            ruleEntities.add(EBS);
            ruleEntities.add(ELASTICACHE);
            ruleEntities.add(ELASTICACHENODE);
            ruleEntities.add(REDSHIFTCLUSTERNODE);
            ruleEntities.add(ELASTICMAPREDUCE);
            ruleEntities.add(EMRBOOTSTRAPACTION);
            ruleEntities.add(EMRINSTANCEGROUP);
            ruleEntities.add(EMRSTEP);
            ruleEntities.add(KINESIS);
            ruleEntities.add(VPN);
            ruleEntities.add(GLOBAL_SECONDARY_INDEX);
            ruleEntities.add(LAMBDA);
            ruleEntities.add(MACHINE_LEARNING);
            ruleEntities.add(STORAGE_GATEWAY);
            ruleEntities.add(GATEWAY_VOLUME);
            ruleEntities.add(CLOUDFRONT);
            ruleEntities.add(WEBSITE);
            ruleEntities.add(SQL_SERVER);
            ruleEntities.add(SQL_DATABASE);
        }
        return ruleEntities;
    }

    public static List<RuleEntity> getRuleEntitiesByCloudType(String cloudType) {
        if (!StringUtil.isEmpty(cloudType)) {
            switch (cloudType.toUpperCase()) {
                case "AWS": {
                    return Arrays.asList(DEVICE, AUTO_SCALING, DYNAMO_DB, EBS, ELASTICACHE, LOAD_BALANCER, RDS, REDSHIFT, ROUTE_53, SNS, SQS, KINESIS, CLOUDFRONT, LAMBDA, MACHINE_LEARNING, STORAGE_GATEWAY);
                }
                case "AZURE": {
                    return Arrays.asList(DEVICE, EBS, CLOUD_SERVICE, AFFINITY_GROUP, WEBSITE, SQL_SERVER, SQL_DATABASE);
                }
                case "GOOGLE": {
                    return Arrays.asList(DEVICE);
                }
            }
            return null;
        }
        return null;
    }

    public static RuleEntity getRuleEntityBySourceType(SourceType sourceType) {
        if (sourceType != null) {
            switch (sourceType.name()) {
                case "SERVICE": {
                    return SERVICEGROUP;
                }
                case "DEVICE_GROUP": {
                    return DEVICEGROUP;
                }
            }
            return RuleEntity.lookup(sourceType.name());
        }
        return null;
    }

    static {
        ruleEntities = null;
    }
}

