/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.dto.schedule;

import java.io.Serializable;

public class Pattern
implements Serializable {
    private String type;
    private String dayFrequency;
    private String weekDays;
    private String dayOfMonth;
    private String monthReoccFreq;
    private String weekIndex;
    private String dayOfWeek;
    private String frequency;
    private Integer repeatFrequency;
    private String repeatType;
    public static final String FIRST_WEEK = "First";
    public static final String SECOND_WEEK = "Second";
    public static final String THIRD_WEEK = "Third";
    public static final String FORTH_WEEK = "Fourth";
    public static final String FIFTH_WEEK = "Fifth";
    public static final String LAST_WEEK = "Last";
    public static final String EVERYDAY = "everyday";
    public static final String EVERY_WEEKDAY = "every weekday";
    public static final String DAILY_PATTERN = "daily";
    public static final String WEEKLY_PATTERN = "weekly";
    public static final String MONTHLY_PATTERN = "monthly";
    public static final String RUN_ONCE = "run once";
    public static final String NEVER = "never";
    public static final String RECURRENCE = "recurrence";
    public static final String DAYS = "days";
    public static final String HOURS = "hours";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDayFrequency() {
        return this.dayFrequency;
    }

    public void setDayFrequency(String dayFrequency) {
        this.dayFrequency = dayFrequency;
    }

    public String getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(String weekDays) {
        this.weekDays = weekDays;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public String getMonthReoccFreq() {
        return this.monthReoccFreq;
    }

    public void setMonthReoccFreq(String monthReoccFreq) {
        this.monthReoccFreq = monthReoccFreq;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getWeekIndex() {
        return this.weekIndex;
    }

    public void setWeekIndex(String weekIndex) {
        this.weekIndex = weekIndex;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public Integer getRepeatFrequency() {
        return this.repeatFrequency;
    }

    public void setRepeatFrequency(Integer repeatFrequency) {
        this.repeatFrequency = repeatFrequency;
    }

    public String getRepeatType() {
        return this.repeatType;
    }

    public void setRepeatType(String repeatType) {
        this.repeatType = repeatType;
    }

    public static short getDayQualifierOfMonthValue(String weekIndex) throws Exception {
        short dayQualifierOfMonth = 0;
        switch (weekIndex) {
            case "First": {
                dayQualifierOfMonth = 1;
                break;
            }
            case "Second": {
                dayQualifierOfMonth = 2;
                break;
            }
            case "Third": {
                dayQualifierOfMonth = 3;
                break;
            }
            case "Fourth": {
                dayQualifierOfMonth = 4;
                break;
            }
            case "Last": {
                dayQualifierOfMonth = 6;
                break;
            }
            default: {
                throw new Exception("Invalid weekIndex received: " + weekIndex + ". It should be in 'First/Second/Third/Fourth/Last'.");
            }
        }
        return dayQualifierOfMonth;
    }

    public static String getDayQualifierOfMonthString(short weekIndex) throws Exception {
        switch (weekIndex) {
            case 1: {
                return FIRST_WEEK;
            }
            case 2: {
                return SECOND_WEEK;
            }
            case 3: {
                return THIRD_WEEK;
            }
            case 4: {
                return FORTH_WEEK;
            }
            case 6: {
                return LAST_WEEK;
            }
        }
        throw new Exception("Invalid weekIndex received: " + weekIndex + ". It should be '1 or 2 or 3 or 4 or6'.");
    }
}

