/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.incident;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.vistara.sdk.dto.incident.Incident;
import com.vistara.sdk.dto.incident.TicketResponse;
import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.SdkUtil;

public class IncidentAPIClient
implements APIConstants {
    private static IncidentAPIClient _instance = null;
    private String apiBaseURI = null;
    private String tenantId = null;
    private String appName = null;
    private String authType = "Oauth2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IncidentAPIClient getInstance(String tenantId, String integrationName) throws Exception {
        if (_instance != null) return _instance;
        Class<IncidentAPIClient> clazz = IncidentAPIClient.class;
        synchronized (IncidentAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new IncidentAPIClient(tenantId, integrationName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IncidentAPIClient getInstance(String tenantId) throws Exception {
        if (_instance != null) return _instance;
        Class<IncidentAPIClient> clazz = IncidentAPIClient.class;
        synchronized (IncidentAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new IncidentAPIClient(tenantId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    public IncidentAPIClient(String tenantId, String integrationName) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (integrationName == null || integrationName.isEmpty()) {
            throw new Exception("Integration Name should not be null or empty.");
        }
        this.tenantId = tenantId;
        this.appName = integrationName;
    }

    public IncidentAPIClient(String tenantId) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        this.tenantId = tenantId;
    }

    public String createIncident(String jsonPayload) throws Exception {
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL("/incidents");
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String createIncident(Incident incident) throws Exception {
        if (incident == null) {
            throw new Exception("Incident object should not be null");
        }
        Gson gson = new Gson();
        String jsonPayload = gson.toJson(incident);
        return this.createIncident(jsonPayload);
    }

    public String updateIncident(Incident incident) throws Exception {
        if (incident == null) {
            throw new Exception("Incident object should not be null");
        }
        Gson gson = new Gson();
        String jsonPayload = gson.toJson(incident);
        return this.updateIncident(incident.getId(), jsonPayload);
    }

    public String updateIncident(String incidentId, String jsonPayload) throws Exception {
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL("/incidents/" + incidentId);
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String createIncidentMigration(Incident incident) throws Exception {
        if (incident == null) {
            throw new Exception("Incident object should not be null");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String jsonPayload = mapper.writeValueAsString((Object)incident);
        String apiURL = this.getApiBaseURI() + "/api/v2/tenants/" + incident.getClient().getUniqueId() + "/incidentsMigration";
        SdkUtil.getInstance().setApiBaseURI(this.getApiBaseURI());
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String updateClientTicketModule(String orgId) throws Exception {
        if (orgId == null) {
            throw new Exception("OrgId Id should not be null");
        }
        String apiURL = this.getApiBaseURI() + "/api/v2/tenants/" + orgId + "/ticketModule";
        SdkUtil.getInstance().setApiBaseURI(this.getApiBaseURI());
        return SdkUtil.getInstance().getRequest(apiURL);
    }

    public String getIncident(String incidentId) throws Exception {
        if (incidentId == null || incidentId.isEmpty()) {
            throw new Exception("Invalid incident id.");
        }
        String apiURL = this.getAPIURL("/incidents/" + incidentId);
        return SdkUtil.getInstance().getRequest(apiURL);
    }

    public String getCustomFields(String classCode) throws Exception {
        if (classCode == null || classCode.isEmpty()) {
            throw new Exception("Invalid class code");
        }
        String apiURL = this.getAPIURL("/customFields/" + classCode);
        return SdkUtil.getInstance().getRequest(apiURL);
    }

    public String createIncidentResponse(String incidentId, TicketResponse ticketResponse) throws Exception {
        if (incidentId == null || incidentId.isEmpty()) {
            throw new Exception("Invalid IncidentId");
        }
        if (ticketResponse == null) {
            throw new Exception("TicketResponcse object should not be null");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String jsonPayload = mapper.writeValueAsString((Object)ticketResponse);
        return this.createIncidentResponse(incidentId, jsonPayload);
    }

    public String createIncidentResponse(String incidentId, String jsonPayload) throws Exception {
        if (incidentId == null || incidentId.isEmpty()) {
            throw new Exception("Invalid IncidentId");
        }
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL("/incidents/" + incidentId + "/responses");
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String createMigrationIncidentResponse(String incidentId, String clientId, TicketResponse ticketResponse) throws Exception {
        if (incidentId == null || incidentId.isEmpty()) {
            throw new Exception("Invalid IncidentId");
        }
        if (ticketResponse == null) {
            throw new Exception("TicketResponcse object should not be null");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String jsonPayload = mapper.writeValueAsString((Object)ticketResponse);
        String apiURL = this.getApiBaseURI() + "/api/v2/tenants/" + clientId + "/incidents/" + incidentId + "/responses";
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String createIncidentNotes(String incidentId, String jsonPayload) throws Exception {
        if (incidentId == null || incidentId.isEmpty()) {
            throw new Exception("Invalid IncidentId");
        }
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL("/incidents/" + incidentId + "/notes");
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String updateIncidentNotes(String incidentId, String notesId, String jsonPayload) throws Exception {
        if (incidentId == null || incidentId.isEmpty()) {
            throw new Exception("Invalid IncidentId");
        }
        if (notesId == null || notesId.isEmpty()) {
            throw new Exception("Invalid NotesId");
        }
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL("/incidents/" + incidentId + "/notes/" + notesId);
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    private String getAPIURL(String urlSubStr) throws Exception {
        String apiBaseURI = this.getApiBaseURI();
        SdkUtil.getInstance().setApiBaseURI(apiBaseURI);
        String apiURL = apiBaseURI;
        switch (this.authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "None": {
                apiURL = apiURL + "/integrations/" + this.tenantId + "/apps/" + this.appName + urlSubStr;
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
        return apiURL;
    }

    public void setBasicAuthentication(String apiUserName, String apiPassword) throws Exception {
        if (apiUserName == null || apiUserName.isEmpty()) {
            throw new Exception("API UserName should not be null or empty.");
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            throw new Exception("API Password should not be null or empty.");
        }
        this.authType = "Basic";
        SdkUtil.getInstance().setApiUserName(apiUserName);
        SdkUtil.getInstance().setApiPassword(apiPassword);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setOAUTH2Authentication(String apiKey, String apiSecret) throws Exception {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("API Key should not be null or empty.");
        }
        if (apiSecret == null || apiSecret.isEmpty()) {
            throw new Exception("API Secret should not be null or empty.");
        }
        this.authType = "Oauth2";
        SdkUtil.getInstance().setApiKey(apiKey);
        SdkUtil.getInstance().setApiSecret(apiSecret);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setWebhookAuthentication() throws Exception {
        this.authType = "None";
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setApiBaseURI(String apiBaseURI) {
        this.apiBaseURI = apiBaseURI;
    }

    public String getApiBaseURI() {
        if (this.apiBaseURI == null) {
            return "https://api.vistara.io";
        }
        return this.apiBaseURI;
    }
}

