/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.maintenance;

import com.google.gson.Gson;
import com.vistara.sdk.dto.device.ScheduleMaintenance;
import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.SdkUtil;

public class ScheduleMaintenanceAPIClient
implements APIConstants {
    private static ScheduleMaintenanceAPIClient _instance = null;
    private String apiBaseURI = null;
    private String tenantId = null;
    private String appName = null;
    private String authType = "Oauth2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduleMaintenanceAPIClient getInstance(String tenantId, String integrationName) throws Exception {
        if (_instance != null) return _instance;
        Class<ScheduleMaintenanceAPIClient> clazz = ScheduleMaintenanceAPIClient.class;
        synchronized (ScheduleMaintenanceAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new ScheduleMaintenanceAPIClient(tenantId, integrationName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduleMaintenanceAPIClient getInstance(String tenantId) throws Exception {
        if (_instance != null) return _instance;
        Class<ScheduleMaintenanceAPIClient> clazz = ScheduleMaintenanceAPIClient.class;
        synchronized (ScheduleMaintenanceAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new ScheduleMaintenanceAPIClient(tenantId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    public ScheduleMaintenanceAPIClient(String tenantId, String integrationName) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (integrationName == null || integrationName.isEmpty()) {
            throw new Exception("Integration Name should not be null or empty.");
        }
        this.tenantId = tenantId;
        this.appName = integrationName;
    }

    public ScheduleMaintenanceAPIClient(String tenantId) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        this.tenantId = tenantId;
    }

    public String createOrUpdateScheduleMaintenance(String jsonPayload) throws Exception {
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL("/scheduleMaintenances");
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String createOrUpdateScheduleMaintenance(ScheduleMaintenance scheduleMaintenance) throws Exception {
        if (scheduleMaintenance == null) {
            throw new Exception("Schedule Maintenance object should not be null");
        }
        Gson gson = new Gson();
        String jsonPayload = gson.toJson(scheduleMaintenance);
        return this.createOrUpdateScheduleMaintenance(jsonPayload);
    }

    public String getScheduleMaintenance(long scheduleMaintenanceId) throws Exception {
        if (scheduleMaintenanceId <= 0L) {
            throw new Exception("Invalid Shedule Maintenance Id : " + scheduleMaintenanceId);
        }
        String apiURL = this.getAPIURL("/scheduleMaintenances/" + scheduleMaintenanceId);
        return SdkUtil.getInstance().getRequest(apiURL);
    }

    public String getScheduleMaintenances(String queryString) throws Exception {
        if (queryString == null || queryString.isEmpty()) {
            throw new Exception("QueryString should not be null or empty");
        }
        String apiURL = this.getAPIURL("/scheduleMaintenances/search?queryString=" + queryString);
        return SdkUtil.getInstance().getRequest(apiURL);
    }

    public String deleteScheduleMaintenance(long scheduleMaintenanceId) throws Exception {
        if (scheduleMaintenanceId <= 0L) {
            throw new Exception("Invalid Shedule Maintenance Id : " + scheduleMaintenanceId);
        }
        String apiURL = this.getAPIURL("/scheduleMaintenances/" + scheduleMaintenanceId);
        return SdkUtil.getInstance().deleteRequest(apiURL);
    }

    private String getAPIURL(String urlSubStr) throws Exception {
        String apiBaseURI = this.getApiBaseURI();
        SdkUtil.getInstance().setApiBaseURI(apiBaseURI);
        String apiURL = apiBaseURI;
        switch (this.authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "None": {
                apiURL = apiURL + "/integrations/" + this.tenantId + "/apps/" + this.appName + urlSubStr;
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
        return apiURL;
    }

    public void setBasicAuthentication(String apiUserName, String apiPassword) throws Exception {
        if (apiUserName == null || apiUserName.isEmpty()) {
            throw new Exception("API UserName should not be null or empty.");
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            throw new Exception("API Password should not be null or empty.");
        }
        this.authType = "Basic";
        SdkUtil.getInstance().setApiUserName(apiUserName);
        SdkUtil.getInstance().setApiPassword(apiPassword);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setOAUTH2Authentication(String apiKey, String apiSecret) throws Exception {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("API Key should not be null or empty.");
        }
        if (apiSecret == null || apiSecret.isEmpty()) {
            throw new Exception("API Secret should not be null or empty.");
        }
        this.authType = "Oauth2";
        SdkUtil.getInstance().setApiKey(apiKey);
        SdkUtil.getInstance().setApiSecret(apiSecret);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setWebhookAuthentication() throws Exception {
        this.authType = "None";
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setApiBaseURI(String apiBaseURI) {
        this.apiBaseURI = apiBaseURI;
    }

    public String getApiBaseURI() {
        if (this.apiBaseURI == null) {
            return "https://api.vistara.io";
        }
        return this.apiBaseURI;
    }

    public static void main(String[] args) {
        try {
            String response = null;
            ScheduleMaintenanceAPIClient scheduleMaintenanceAPIClient = ScheduleMaintenanceAPIClient.getInstance("client_20");
            scheduleMaintenanceAPIClient.setApiBaseURI("https://localhost:9443");
            scheduleMaintenanceAPIClient.setOAUTH2Authentication("AyEYgZ7H6P473gaSM4nQGaSAbKqF5bQy", "EDzvdX2zM8CDGFvH5NkxyzFsxAsbVCQzCJ6KPBySTS46Trv5D8aSTfZDhBgM8ZCD");
            response = scheduleMaintenanceAPIClient.getScheduleMaintenance(78L);
            System.out.println("Response :" + response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

