/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.metric;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vistara.sdk.dto.device.IndexedResource;
import com.vistara.sdk.dto.metric.TimeSeries;
import com.vistara.sdk.dto.response.Response;
import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.APITemplate;
import com.vistara.sdk.utils.SdkUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricAPI
implements APIConstants {
    private static Logger logger = LoggerFactory.getLogger(MetricAPI.class);
    static String OK = "200";

    public static List<TimeSeries> getMetricData(String metric, String clientId, IndexedResource dev, long sTime, long eTime) throws Exception {
        String URI2 = MetricAPI.getMetricURI(metric, clientId, dev.getId(), sTime, eTime);
        int retryCnt = 0;
        String jsonData = null;
        Response res = null;
        do {
            try {
                jsonData = APITemplate.getInstance(clientId).getRequest(URI2);
                if (jsonData != null && (res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){})) != null && res.getStatus().equals(OK) && res.getStatus_message() != null) {
                    return (List)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<List<TimeSeries>>(){});
                }
                ++retryCnt;
            }
            catch (Exception e) {
                logger.error("@ Fetching metric data for URI:" + URI2);
                logger.error("", e);
            }
        } while ((jsonData == null || res.getStatus().equals("504")) && retryCnt < 5);
        return null;
    }

    public static String getMetricURI(String metric, String clientId, String devId, long sTime, long eTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("metric/search?");
        sb.append("tenant=").append(clientId);
        sb.append("&rtype=").append("DEVICE");
        sb.append("&resource=").append(devId);
        sb.append("&metric=").append(metric);
        sb.append("&startTime=").append(sTime);
        sb.append("&endTime=").append(eTime);
        sb.append("&fetch=0");
        return sb.toString();
    }

    public static String getJsonData(String uri) throws Exception {
        SdkUtil util = SdkUtil.getInstance();
        try {
            String rawResp = util.getRequest(uri);
            Response response = (Response)new ObjectMapper().readValue(rawResp, (TypeReference)new TypeReference<Response>(){});
            if (response.getStatus() != null && response.getStatus().equals(OK) && response.getStatus_message() != null) {
                return response.getStatus_message();
            }
        }
        catch (Exception e) {
            logger.error(uri);
            logger.error(e.getMessage(), e);
        }
        return null;
    }
}

